﻿/*
	VERSION:		1.0
	
	DESCRIPTION:
		This is a simple object-based music system.  (doesn't need a movieClip)
		It extends the Sound() class,  but use stopMusic() instead of stop().
	
	USAGE:
		#include "makeMusic.as"
		MUSIC = makeMusic();
		MUSIC.play( "songName" );
		
	FUNCTIONS:
		play( "songName" );
		stopMusic();
		fadeOut( seconds );
*/
makeStreamingMusic = function()
{
	var _this = new Sound();
	_this.volume = 100;
	_this.isPlaying = false;
	_this.songName = "";
	
	
	
	_this.play = function( songName )
	{
		if(_this.songName != songName)
		{
			//_this.attachSound( songName );
			_this.loadSound( songName, true );
			_this.songName = songName;
			_this.isPlaying = false;
		}// if: a new song is specified
		
		if( _this.isPlaying == false )
		{
			_this.start();
			_this.volume = 100;
			_this.setVolume( _this.volume );
			_this.isPlaying = true;
		}// if:  music is not playing
	}// play()
	
	// Loops the sound playback
	_this.onSoundComplete = function()
	{
		_this.start();
	}// onSoundComplete()
	
	
	
	_this.stopMusic = function()
	{
		_this.stop();
		_this.isPlaying = false;
	}// stopMusic()
	
	
	
	// setVolume()
	
	
	
	_this.fadeOut = function( seconds )
	{
		if(_this.volume > 0  &&
		   _this.fade == undefined)
		{
			// tween volume from current to ZERO
			var startVolume = _this.getVolume();
			_this.fade = new mx.transitions.Tween( _this, "volume", null, startVolume, 0, seconds, true);
			
			// onChange
			_this.fade.onMotionChanged = function()
			{
				_this.setVolume( this.position );
			}// onMotionChanged()
			
			// onDone
			_this.fade.onMotionFinished = function()
			{
				delete _this.fade;
				_this.stopMusic();
			}// onMotionFinished()
		}// if:  volume isn't ZERO
	}// fadeOut()
	
	
	
	return _this;
}// makeStreamingMusic()